#include "SpotLight.h"

SpotLight::SpotLight(int id, std::vector<GLfloat> pos, std::vector<GLfloat> dir, float cut, float exp) : Light(id, pos)
{
	//Set values passed in, pass some to base constructor
	_Position[3] = 1.0f;
	_Direction = dir;
	_Cutoff = cut;
	_Exponent = exp;
}


SpotLight::~SpotLight()
{
}



void SpotLight::Render()
{
	//Render Ambient, Diffuse, Position, Spot Light and Attenuation values
	glLightfv(_ID, GL_AMBIENT, &Ambient[0]);
	glLightfv(_ID, GL_DIFFUSE, &Diffuse[0]);
	glLightfv(_ID, GL_POSITION, &_Position[0]);
	glLightfv(_ID, GL_SPOT_DIRECTION, &_Direction[0]);
	glLightf(_ID, GL_SPOT_CUTOFF, _Cutoff);
	glLightf(_ID, GL_SPOT_EXPONENT, _Exponent);
	glLightf(_ID, GL_CONSTANT_ATTENUATION, _ConstAtten);
	glLightf(_ID, GL_LINEAR_ATTENUATION, _LinearAtten);
	glLightf(_ID, GL_QUADRATIC_ATTENUATION, _QuadraticAtten);
}
